import UIKit

@objc
public protocol GMSScreenSharingViewControllerDelegate {
    
    func updateScreenSharingState(state: Bool)
}

class GMSScreenSharingViewController: UIViewController, UITextFieldDelegate {
    
    var delegate: GMSScreenSharingViewControllerDelegate?
    
    var appDelegate: GMSAppDelegate
    
    @IBOutlet weak var enabledSwitch: UISwitch!
    @IBOutlet weak var serviceNameField: UITextField!
    @IBOutlet weak var accessCodeField: UITextField!
    @IBOutlet weak var errorTextView: UITextView!
    
    required init?(coder aDecoder: NSCoder) {
        appDelegate = UIApplication.shared.delegate as! GMSAppDelegate
        super.init(coder: aDecoder)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        if appDelegate.screenSharingServiceName != nil {
            serviceNameField.text = appDelegate.screenSharingServiceName
        }
        if appDelegate.screenSharing == nil {
            let view = appDelegate.window!.rootViewController!.view
            
            appDelegate.screenSharing = GMSScreenSharing()
        }
        
        updateUIState()
    }
    
    override func viewDidAppear(_ animated: Bool) {
        appDelegate.screenSharing.addObserver(self, forKeyPath: "isOn", options: NSKeyValueObservingOptions.new, context: nil)
        appDelegate.screenSharing.addObserver(self, forKeyPath: "accessCode", options: NSKeyValueObservingOptions.new, context: nil)
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        appDelegate.screenSharing.removeObserver(self, forKeyPath: "isOn")
        appDelegate.screenSharing.removeObserver(self, forKeyPath: "accessCode")
    }
    
    override func observeValue(forKeyPath keyPath: String?, of ofObject: Any?, change: [NSKeyValueChangeKey : Any]?,
        context: UnsafeMutableRawPointer?) {
        
        updateUIState()
    }
    
    // Called when Return is tapped when finished editing ServiceName TextField
    func textFieldShouldReturn(textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        appDelegate.screenSharingServiceName = textField.text
        updateUIState()
        return false
    }
    
    func updateUIState() {
        if let text = serviceNameField.text {
            enabledSwitch.isEnabled = !text.isEmpty
        }
        else {
            enabledSwitch.isEnabled = false
        }
        enabledSwitch.isOn = appDelegate.screenSharing.isOn
        serviceNameField.isEnabled = !enabledSwitch.isOn
        accessCodeField.text = appDelegate.screenSharing.accessCode
        
        let error = appDelegate.screenSharing.error
        if error != nil {
            errorTextView.text = appDelegate.screenSharing.error!.localizedDescription
            errorTextView.isHidden = false
        }
        else {
            errorTextView.text = ""
            errorTextView.isHidden = true
        }
    }
    
    @IBAction func switchValueChanged(sender: AnyObject) {
        
        if enabledSwitch.isOn {
            appDelegate.screenSharing!.startSharingWithServiceName(serviceName: serviceNameField.text!,
                view: appDelegate.window!.rootViewController!.view)
        }
        else {
            appDelegate.screenSharing!.stopSharing()
        }
    }
}
